// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'marionette',
    'App',
    'modules/appointments/appointments-module',

    'modules/form/section-view',
    'text!modules/new-appointment-request/views/requests/purpose/type-of-visit-warning.html',
    'text!modules/new-appointment-request/views/requests/purpose/phone-call-warning.html',
    'json!modules/new-appointment-request/views/requests/form.json',
],
function(
    _,
    Marionette,
    app,
    module,
    SectionView,
    _warningTemplate,
    _phoneCallWarning,
    metadata
) {
    'use strict';

    return SectionView.extend({
        collectionEvents: {'change:value': 'updateFDNS   el'},
        modelEvents: {
            // eslint-disable-next-line max-len
            'change:purposeOfVisit': 'showHideOtherPurposeOfVisitQuestionAndValidation selectTypeOfVisit showHidePhoneCallWarning',
            'change:visitType': 'showHideVideoConferenceWarning',
        },
        initialize: function(options) {
            var sectionName = 'request-details-type-purpose-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
            this.validator = options.validator;
        },
        onRender: function() {
            this.initChildren();
            this.appendVideoConferenceWarning();
            this.appendPhoneCallWarning();
            this.showHideOtherPurposeOfVisitQuestionAndValidation();
        },
        appendPhoneCallWarning: function() {
            this.$el.find('[for="visitType-phone-call"] .label-text')
                .append(_phoneCallWarning);
            this.showHidePhoneCallWarning(this.model);
        },
        showHidePhoneCallWarning: function(model) {
            var $phoneCallWarning;

            if (!this.isDestroyed()) {
                $phoneCallWarning = this.$el.find('.phone-call-warning');

                $phoneCallWarning.toggleClass('hidden',
                    (model.getCareId() !== module.clinicalServicesConstants.PRIMARY_CARE_ID) ||
                    (model.get('purposeOfVisit') !== 'Medication Concern'));
            }
        },
        selectTypeOfVisit: function() {
            if (typeof gas !== 'undefined') {
                // eslint-disable-next-line max-len
                gas('send', 'event', 'veteran-appointment', 'appointment-request-purpose-selected', this.model.get('purposeOfVisit'));
            }

            if (
                (this.model.getCareId() === module.clinicalServicesConstants.PRIMARY_CARE_ID) &&
                (this.model.get('purposeOfVisit') === 'Medication Concern')
            ) {
                // section-view has listener to update model accordingly
                this.collection.get('visitType').set('value', 'Phone Call');
                this.$el.find('#visitType-phone-call').prop('checked', true);
            } else {
                // section-view has listener to update model accordingly
                this.collection.get('visitType').set('value', 'Office Visit');
                this.$el.find('#visitType-office-visit').prop('checked', true);
            }
        },
        appendVideoConferenceWarning: function() {
            this.$el.find('.type-of-visit-question')
                .append(_.template(_warningTemplate)(this.templateContext()));
            this.showHideVideoConferenceWarning(this.model);
        },
        showHideVideoConferenceWarning: function(model) {
            var $otherPurposeOfVisit;

            if (!this.isDestroyed()) {
                $otherPurposeOfVisit = this.$el.find('.video-conference-warning');
                $otherPurposeOfVisit.toggleClass('hidden',
                    (model.get('visitType') !== 'Video Conference'));
            }
        },
        showHideOtherPurposeOfVisitQuestionAndValidation: function(model) {
            var $otherPurposeOfVisit;
            var isHidingQuestion;

            if (!this.isDestroyed()) {
                $otherPurposeOfVisit = this.$el.find('.other-purpose-of-visit-question');
                isHidingQuestion = !(this.model.has('purposeOfVisit') && this.model.get('purposeOfVisit') === 'Other');

                $otherPurposeOfVisit.toggleClass('hidden',
                    isHidingQuestion);

                if (isHidingQuestion) {
                    this.hideValidationErrorsFor($otherPurposeOfVisit);
                }
            }
        },
    });
});
